 aR  w - mP9      h	 o     nSystem-wide$NOLIST

; SS:SP does not have to be set up here.  It is initialized by the loader.

        NAME  MiniStart

PUBLIC  MniRemoveLibrary, DosAlloc, DosFree

cr                   EQU 0DH

eMsMemoryTrashed     EQU 7
eMsOutOfMemory       EQU 8
eMsInvalidBlock      EQU 9

padIntVect           EQU 60H
dfltMemPool          EQU 0

unloadLibraryCmd     EQU 2

loadFailMsgID        EQU 0
loadOkayMsgID        EQU 1
unloadFailMsgID      EQU 2
unloadOkayMsgID      EQU 3

comSpecBufferOffset  EQU 2CH

MemType STRUC
  signature   DB ?	; 'M' for valid blk, 'Z' for last valid blk
  owner	     DW ?	; 0 for free blk, 'XX' for allocated blk
  numBlks     DW ?	; Number of paragraphs in block (w/o header)
MemType ENDS


CGROUP   GROUP CODE
DGROUP   GROUP DATA


DATA     SEGMENT  PUBLIC 'DATA'
DATA     ENDS


CODE     SEGMENT  PUBLIC 'CODE'

EXTRN  pMyProgName: DWORD
EXTRN  MsProgramName: NEAR, MsGetArgument: NEAR, MsHexOut: NEAR
EXTRN  MiniGRiDEntry: FAR

ASSUME   CS:CGROUP

firstMemBlk DW ?
memBlkSize  DW ?
intVectAddr DW ?
oldEntryOff DW ?
oldEntrySeg DW ?
$EJECT

; MniInstallLibrary

; This routine will do everything neccessary to install this module as a
; terminate and stay resident (TSR) library  for the GRiDPad API.  There are
; 3 switches that are looked at on the command line.  The /I=nn switch can
; be used to specify an optional interrupt vector for the library.  The /M=nn
; switch can be used to create a local memory heap/pool when it is needed, as
; is the case if all of memory is allocated by some MsDos program.  And the /R
; switch is used to make this program into a Remove program of any GRiDPad
; API libraries that are already installed.

; The following is arranged for this reason.  It is assumed that the longest
; argument for the GRiDPad library API will be 20 bytes since the typical
; arguments have the format '/I=60' and '/M=64'.  If the argument is longer
; then it will overwrite the exitMsgs, which will show up when the exitMsgs
; are displayed.  If it is longer than the buffer and the exitMsgs combined
; then it may overwrite some of the initial code that has already been
; executed.

arg              DB 20 DUP (?)	; Assuming longest argument is 20 bytes

warningMsg       DB 'WARNING: ', '$'
apiNameMsg       DB 'GRiDPad API library ', '$'
loadOkayMsg      DB 'successfully installed at', '$'
loadFailMsg      DB 'is already installed at', '$'
unloadOkayMsg    DB 'successfully removed from', '$'
unloadFailMsg    DB 'is not present at', '$'
atIntrMsg        DB ' interrupt address ', '$'
memSizeMsg       DB 'Memory pool size (in KBytes) = ', '$'
hCrLfMsg         DB 'H', 0DH, 0AH, '$'

apiSignatureText DB  11, 'GRiDPad API'
apiSignatureLen  EQU 12


pgmBlkSize EQU WORD PTR [BP-2]
argLength  EQU WORD PTR [BP-4]
delim	  EQU BYTE PTR [BP-5]
removeFlag EQU BYTE PTR [BP-6]

MniInstallLibrary PROC NEAR
Start:
	MOV	BP, SP	; Establish top of stack pointer
	SUB	SP, 6	; Make room for local variables
	PUSH	CS
	POP	DS	; DS points to CGROUP

	MOV	DS:firstMemBlk, SS	; Use stack as beginning of memory pool
	MOV	DS:intVectAddr, padIntVect

	MOV	DX, SS
	MOV	AX, ES	; ES => program segment prefix here
	SUB	DX, AX	; DX = number of paragraphs needed for pgm
	MOV	pgmBlkSize, DX	; The pgm's blk size (save for exit time)
	MOV	DS:memBlkSize, dfltMemPool
	MOV	removeFlag, 0	; Default is don't remove if already exists

	PUSH	AX	; Save room on stack for program name length
	MOV	SI, SP
	PUSH	SS
	PUSH	SI	; Need to get the name of this program
	CALL	MsProgramName	; to be able to look for resources later
	MOV	WORD PTR CS:pMyProgName+2, ES
	MOV	WORD PTR CS:pMyProgName+0, BX
	POP	CX	; Program name's length (Don't care)

GetArgumentLoop:
	LEA	AX, CS:arg
	PUSH	DS	; DS=CS
	PUSH	AX
	LEA	AX, argLength
	PUSH	SS
	PUSH	AX
	CALL	MsGetArgument	; delim = MsGetArgument (@argBuff, @length);
	MOV	delim, AL
	MOV	CX, argLength
	JCXZ	StoreIntVector
	CMP	CX, 2
	JB	GetArgumentLoop	; Minimum valid argument '/R' has 2 chars

ParseArgument:
	CLD
	SUB	CX, 2	; Account for the '/' and letter following
	LEA	SI, CS:arg	; DS=CS

	LODSB
	CMP	AL, '/'
	JNE	GetArgumentLoop

	LODSB
	AND	AL, 0DFH	; Force digit to uppercase
	CMP	AL, 'R'
	JE	ParseArgSaveRemoveFlag

	CMP	AL, 'I'
	JE	ParseArgContinue

	CMP	AL, 'M'
	JNE	GetArgumentLoop

ParseArgContinue:
	CMP	CX, 2
	JB	GetArgumentLoop	; Minumum requirement is the '=' and 1 digit

	DEC	CX	; Account for the '='
	MOV	BL, AL	; Save 'I' or 'M' flag in BL
	LODSB
	CMP	AL, '='
	JNE	GetArgumentLoop

	CALL	ParseNumber
	JC	GetArgumentLoop

	CMP	BL, 'I'
	JE	ParseArgSaveAsIntVectAddr

	CMP	BL, 'M'
	JNE	GetArgumentLoop

ParseArgSaveAsMemBlkSize:
	MOV	CL, 6	; Multiply by 64 (1K / 16 bytes per block)
	SHL	DX, CL
	MOV	DS:memBlkSize, DX
	JMP	SHORT ParseArgNext

ParseArgSaveAsIntVectAddr:
	MOV	DS:intVectAddr, DX
	JMP	SHORT ParseArgNext

ParseArgSaveRemoveFlag:
	MOV	removeFlag, 1

ParseArgNext:
	CMP	delim, cr
	JNE	GetArgumentLoop

StoreIntVector:
	XOR	AX, AX
	MOV	ES, AX
	MOV	BX, DS:intVectAddr
	SHL	BX, 1
	SHL	BX, 1
	LES	DI, DWORD PTR ES:[BX]	; ES:DI => GRiDPad API Entrypoint
	MOV	DS:oldEntryOff, DI
	MOV	DS:oldEntrySeg, ES

CheckForAlreadyLoaded:
	PUSH	DS
	MOV	AX, CS
	MOV	DS, AX
	LEA	SI, CS:apiSignatureText
	ADD	DI, 4	; Sig. is stored at offset 4 from entrypoint
	MOV	CX, apiSignatureLen
	CLD
	REP	CMPSB
	POP	DS
	JNE	StoreIntVectorNotLoaded

	MOV	CX, loadFailMsgID
	CMP	removeFlag, 1	; If the /R option is present
	JE	RemoveLibraryHere	; then try to remove the library
	JMP	MessageAndNormalExit	; Else display load failed message

RemoveLibraryHere:
	MOV	AX, unloadLibraryCmd	; Send unload command to TSR library
	ADD	DS:oldEntryOff, 2	; Indirect entrypoint is at offset 2
	CALL	DWORD PTR DS:oldEntryOff	; Send request to previously loaded library
	PUSH	CS
	POP	DS	; Restore DS to point to CGROUP again

	OR	AX, AX	; If an error was returned by the routine
	JNZ	RemoveLibraryFinish	; then don't do any further processing

	MOV	ES, DX	; Put libraries PDB segment into ES
	MOV	BX, comSpecBufferOffset
	MOV	ES, ES:[BX]	; Address of comspec buffer
	MOV	AH, 49H	; Free the comspec buffer
	INT	21H	; Call MsDos (NOT THE LOCAL MEMORY MGR!)
	JC	RemoveLibraryFinish	; Return if there was an error

	MOV	ES, DX	; Put libraries PDB segment into ES
	MOV	AH, 49H	; Free the library's code buffer
	INT	21H	; Call MsDos (NOT THE LOCAL MEMORY MGR!)
	JC	RemoveLibraryFinish	; Return if there was an error

	XOR	AX, AX	; No error

RemoveLibraryFinish:
	MOV	CX, unloadOkayMsgID	; Display that unload succeeded (if it did)
	JMP	MessageAndNormalExit

StoreIntVectorNotLoaded:
	CMP	removeFlag, 1	; If the /R option is not present
	JNE	StoreIntVectorOkay	; then go ahead and install the library

	MOV	CX, unloadFailMsgID	; If the /R option was present, but the
	JMP	MessageAndNormalExit	; library wasn't, then display error msg

StoreIntVectorOkay:
	XOR	AX, AX
	MOV	ES, AX	; Segment points to interrupt vectors again
	MOV	AX, OFFSET MiniGRiDEntry
	MOV	ES:[BX+0], AX
	MOV	AX, SEG    MiniGRiDEntry
	MOV	ES:[BX+2], AX	; Store MiniGRiD entrypoint at intVectAddr

MessageAndTSRExit:
	MOV	CX, loadOkayMsgID
	CALL	DisplayExitMsgRtn

	MOV	CX, DS:memBlkSize
	JCXZ	TSRSuccessfulExit

	LEA	DX, CS:memSizeMsg
	MOV	AH, 9	; Print a '$-terminated' text message
	INT	21H	; Call MsDos
	MOV	AX, DS:memBlkSize
	MOV	CL, 6	; Divide by 64 (1K / 16 bytes per block)
	SHR	AX, CL
	CALL	SimpleHexByteOut
	LEA	DX, CS:hCrLfMsg
	MOV	AH, 9	; Print a '$-terminated' text message
	INT	21H	; Call MsDos

TSRSuccessfulExit:
	MOV	DX, pgmBlkSize	; Number of blocks needed for program
	MOV	AX, DS:memBlkSize	; Number of blocks needed for memory pool
	ADD	DX, AX	; Add additional needs for memory pool
	MOV	SS:signature, 'Z'	; Initial block is last block
	MOV	SS:owner, 0	; It is free
	MOV	SS:numBlks, AX	; Num of memory blocks available initially

    MOV  AX, 3100H	; Exit w/Keep Process (Term, Stay resident)
    INT  21H	; Call MsDos

MessageAndNormalExit:
	CALL	DisplayExitMsgRtn
    MOV  AX, 4C00H	; Exit program
    INT  21H	; Call MsDos
MniInstallLibrary ENDP
$EJECT

; MniRemoveLibrary

; This routine will restore the interrupt vector at CS:intVectAddr to
; old entry off and old entry seg.  It will return the library's program
; data block (CS-10H) to the caller, so the caller can free the memory
; that had been occupied by the terminate and stay resident (TSR) code.

; Entry

; Exit
;  DX = Segment of program data block (supposedly freeable)
;  AX = Error

MniRemoveLibrary PROC NEAR
	MOV	DX, CS

	XOR	AX, AX
	MOV	ES, AX
	MOV	DI, CS:intVectAddr
	SHL	DI, 1
	SHL	DI, 1
	MOV	AX, 1	; Indicate error
	CMP	DX, ES:[DI+2]	; If the routine at this interrupt
	JNE	MniRemoveLibReturn	; doesn't belong to this code, then return

	MOV	AX, CS:oldEntryOff
	STOSW
	MOV	AX, CS:oldEntrySeg
	STOSW
	XOR	AX, AX	; No error

MniRemoveLibReturn:
	SUB	DX, 10H	; Point to program data block area
	RET
MniRemoveLibrary ENDP
$EJECT

; Parse Number
; This routine currently assumes that the number input is hex.

; Entry
;   DS:SI points to next digit
;   CX = number of digits/characters remaining in argument

; Exit
;   DX = Number
;	If carry flag is set then there were invalid characters in the number

ParseNumber PROC NEAR
	XOR	DX, DX	; Initially number is 0

ParseNumLoop:
	LODSB
	CMP	AL, '0'
	JB	ParseNumRet

	CMP	AL, '9'+1
	JB	AddInDecDigit

	CMP	AL, 'A'
	JB	ParseNumRet

	AND	AL, 0DFH	; Force letter (if it is one) to uppercase
	CMP	AL, 'F'+1
	CMC
	JB	ParseNumRet

AddInHexDigit:
	SUB	AL, 'A'
	ADD	AL, 10
	JMP	SHORT AddInAnyDigit

AddInDecDigit:
	SUB	AL, '0'

AddInAnyDigit:
	MOV	DH, AL
	MOV	AL, 16
	MUL	DL
	ADD	AL, DH
	XCHG	DX, AX
	LOOP	ParseNumLoop
	CLC

ParseNumRet:
	RET
ParseNumber ENDP
$EJECT

; DisplayExitMsgRtn

; This routine will display an exit message with one of three possible
; variations:
;  0) A warning that the library is already present and was not installed
;  1) A message that the library was successfully installed
;  2) A warning that the library is not present and was not removed
;  3) A message that the library was successfully removed

; Entry
;  CX = Msg choice
;  DS = CS

DisplayExitMsgRtn PROC NEAR
	TEST	CL, 1	; If msg variation is 1 or 3
	JNZ	AfterWarning	; then don't display the warning prefix

	LEA	DX, CS:warningMsg
	MOV	AH, 9	; Print a '$-terminated' text message
	INT	21H	; Call MsDos

AfterWarning:
	LEA	DX, CS:apiNameMsg
	MOV	AH, 9	; Print a '$-terminated' text message
	INT	21H	; Call MsDos

	LEA	DX, CS:loadFailMsg
	OR	CX, CX
	JZ	PrintMiddleText

	LEA	DX, CS:loadOkayMsg
	DEC	CX
	JZ	PrintMiddleText

	LEA	DX, CS:unloadFailMsg
	DEC	CX
	JZ	PrintMiddleText

	LEA	DX, CS:unloadOkayMsg

PrintMiddleText:
	MOV	AH, 9	; Print a '$-terminated' text message
	INT	21H	; Call MsDos

	LEA	DX, CS:atIntrMsg
	MOV	AH, 9	; Print a '$-terminated' text message
	INT	21H	; Call MsDos

	MOV	AX, DS:intVectAddr
	CALL	SimpleHexByteOut

	LEA	DX, CS:hCrLfMsg
	MOV	AH, 9	; Print a '$-terminated' text message
	INT	21H	; Call MsDos
	RET
DisplayExitMsgRtn ENDP
$EJECT

; SimpleHexByteOut
; This routine will display the number passed in AL as two hex digits.

; Entry
;   AL = number

SimpleHexByteOut PROC NEAR
	MOV	DL, AL
	MOV	CL, 4
	SHR	DL, CL	; Do high order nibble first
	CMP	DL, 0AH
	JB	MakeNumber1

	ADD	DL, 7H	; Add 7H (For total addition of 37H) for A-F

MakeNumber1:
	PUSH	AX
	ADD	DL, 30H
	MOV	AH, 6	; Display a single character
	INT	21H	; Call MsDos

	POP	DX
	AND	DL, 0FH	; Do the low order nibble next
	CMP	DL, 0AH
	JB	MakeNumber2

	ADD	DL, 7H	; Add 7H (For total addition of 37H) for A-F

MakeNumber2:
	ADD	DL, 30H
	MOV	AH, 6	; Display a single character
	INT	21H	; Call MsDos
	RET
SimpleHexByteOut ENDP
$EJECT

;  DosAlloc

;  This is a procedural interface identical to the INT 21H, function 48H call.
;  This will return a pointer to a block of allocated memory from a local
;  memory pool if memBlkSize is not zero.  If it is zero then it calls MsDos.

;  Entry
;    BX = Number of paragraphs requested

;  Exit (No error; i.e. carry flag not set)
;    AX = Address of block of memory

;  Exit (error; i.e. carry flag set)
;    AX = error code if error
;	 BX is supposed to have number of blocks available!

DosAlloc PROC NEAR
	CMP	CS:memBlkSize, 0
	JNE	DosAllocLocal

DosAllocFromMsDos:
	MOV	AH, 48H
	INT	21H
	RET

DosAllocLocal:
	PUSH	DS
	PUSH	ES
	PUSH	SI
	PUSH	DI
	PUSH	DX
	PUSH	CX
	PUSH	BX
	MOV	DS, CS:firstMemBlk	; top of chain

DosAllocFindBlock:
	CMP	DS:signature, 'M'	; If memory block signature is okay
	JE	DosAllocValidBlock	; then look at this block

	CMP	DS:signature, 'Z'	; If memory block signature is not valid
	JNE	DosAllocBadMemoryExit	; then return eMsMemoryTrashed error

DosAllocValidBlock:
	CMP	DS:owner, 0	; If block is not free
	JNE	DosAllocNextBlk1	; then look at next block

	CMP	DS:numBlks, BX	; If enough blocks to satisfy allocate
	JAE	DosAllocBlockFound	; then use all or at least part of this blk
	JMP	SHORT DosAllocNextBlk2

DosAllocNextBlk1:
	CMP	DS:owner, 'XX'	; If owner signature is not valid
	JNE	DosAllocBadMemoryExit	; then return eMsMemoryTrashed error

DosAllocNextBlk2:
	CMP	DS:signature, 'Z'	; If last block in chain
	JE	DosAllocNoMemoryExit	; then return eMsOutOfMemory error

	MOV	AX, DS	; Segment of current block
	INC	AX	; Skip over blocks memory header
	ADD	AX, DS:numBlks	; Add in size of this memory block
	MOV	DS, AX	; Should be pointing to next block in chain
	JMP	SHORT DosAllocFindBlock	; Keep looking

DosAllocBlockFound:
	MOV	DS:owner, 'XX'	; set to allocated
	JE	DosAllocOkExit	; exit if block is exact size as requested

	MOV	CX, DS:numBlks	; Original size of memory block
	MOV	DS:numBlks, BX	; new size of block
	MOV	AX, DS
	INC	AX	; Skip past memory header
	ADD	AX, BX	; Skip past contents part of memory block
	MOV	ES, AX	; Point to second half of memory block
	MOV	DL, DS:signature	; Save 'M' or 'Z' of newly allocated block
	MOV	ES:signature, DL	; New block should be marked accordingly
	MOV	ES:owner, 0	; Block is free
	SUB	CX, BX	; Number of blocks remaining
	DEC	CX	; Don't count the new blocks header
	MOV	ES:numBlks, CX	; Num blocks in second half of old block
	CMP	DL, 'Z'	; If the alloc'd block was not the last blk
	JNE	DosAllocOkExit	; then return

	MOV	DS:signature, 'M'	; Change for 'last block' to 'not last'

DosAllocOkExit:
	CLC		; error = eOK
	MOV	AX, DS	; Return block's address in AX
	INC	AX	; Give user the usable part of the block
	JMP	SHORT DosAllocExit

DosAllocBadMemoryExit:
	STC
	MOV	AX, eMsMemoryTrashed
	JMP	SHORT DosAllocExit

DosAllocNoMemoryExit:
	XOR	CX, CX	; Block count is initially 0
	MOV	DS, CS:firstMemBlk	; top of chain

DosAvailableMemLoop:
	CMP	DS:signature, 'M'	; If the signature is valid
	JE	DosAvailableMemValid	; then add it in (if it is free)

	CMP	DS:signature, 'Z'	; If the signature is not valid
	JNE	DosAllocBadMemoryExit	; then return an error

DosAvailableMemValid:
	CMP	DS:owner, 'XX'	; If the block is allocated
	JE	DosAvailableMemNext	; then don't count it as free memory

	CMP	DS:owner, 0	; If the block isn't free
	JNE	DosAllocBadMemoryExit	; then return an error

	ADD	CX, DS:numBlks	; Add in blocks of available memory

DosAvailableMemNext:
	CMP	DS:signature, 'Z'	; If this is the end of the chain
	JE	DosAvailableMemRet	; then exit

	MOV	AX, DS	; Segment of current block
	INC	AX	; Skip over blocks memory header
	ADD	AX, DS:numBlks	; Add in size of this memory block
	MOV	DS, AX	; Should be pointing to next block in chain
	JMP	SHORT DosAvailableMemLoop

DosAvailableMemRet:
	POP	BX	; Pop BX off of the stack
	PUSH	CX	; Push total free blocks onto the stack 
	STC		; Error indication
	MOV	AX, eMsOutOfMemory

DosAllocExit:
	POP	BX
	POP	CX
	POP	DX
	POP	DI
	POP	SI
	POP	ES
	POP	DS
	RET
DosAlloc ENDP
$EJECT

;  DosFree

;  This is a procedural interface identical to the INT 21H, function 49H call.
;  This will free a block of memory that was allocated from the local memory
;  pool if memBlkSize is not zero.  If it is zero then it calls MsDos.

;  Entry
;    ES = Address of memory block to be freed

;  Exit
;    AX = Error code if error (carry flag set)

DosFree PROC NEAR
	CMP	CS:memBlkSize, 0
	JNE	DosFreeLocal

DosFreeForMsDos:
	MOV	AH, 49H
	INT	21H
	RET

DosFreeLocal:
	PUSH	DS
	PUSH	ES
	PUSH	SI
	PUSH	DI
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	AX

	MOV	CX, ES	; block to be freed
	DEC	CX	; point to mem header
	MOV	DS, CS:firstMemBlk	; top of chain

DosFreeFindBlock:
	CMP	DS:signature, 'M'	; If this block has a valid signature
	JE	DosFreeBlockValid	; then free it

	CMP	DS:signature, 'Z'	; If this block has a valid signature
	JE	DosFreeBlockValid	; then free it
	JMP	DosFreeBadMemoryExit	; else return error

DosFreeBlockValid:
	MOV	AX, DS
	CMP	AX, CX	; If this is the block
	JE	DosFreeBlockFound	; remove it

	CMP	DS:signature, 'Z'	; If this is not last block
	JNE	DosFreeNextBlock	; then look at next block in chain

DosFreeInvBlkError:
	JMP	DosFreeInvalidBlockExit	; Block not found or already freed

DosFreeNextBlock:
	MOV	BX, AX	; Save previous block in BX
	INC	AX	; Skip over block's memory header
	ADD	AX, DS:numBlks	; Add in size of this memory block
	MOV	DS, AX	; Should be pointing to next block in chain
	JMP	SHORT DosFreeFindBlock	; Keep looking
	
DosFreeBlockFound:
	CMP	DS:owner, 0	; If this block is already free
	JE	DosFreeInvBlkError	; then error

	CMP	DS:owner, 'XX'	; If this block doesn't have valid owner
	JNE	DosFreeBadMemoryExit	; then error

	MOV	DS:owner, 0	; Set owner to indicate free block
	CMP	DS:signature, 'Z'	; If at end of the memory chain
	JE	DosFreeCombineAbove	; then can't combine with block after this

DosFreeCombineBelow:
	MOV	AX, DS
	INC	AX	; Skip past block's header
	ADD	AX, DS:numBlks	; Skip past block's content
	MOV	ES, AX	; Points to next block in chain

	CMP	ES:signature, 'M'	; If valid memory block
	JE	DosFreeCombineIfFree	; then combine if free block

	CMP	ES:signature, 'Z'	; If not valid signature
	JNE	DosFreeBadMemoryExit	; then error

DosFreeCombineIfFree:
	CMP	ES:owner, 0	; If next block is free also
	JE	DosFreeCombineWithBelow	; then combine with the block just freed

	CMP	ES:owner, 'XX'	; Else if the owner is not valid
	JNE	DosFreeBadMemoryExit	; then error
	JMP	SHORT DosFreeCombineAbove

DosFreeCombineWithBelow:
	MOV	AL, ES:signature	; Take next block's signature
	MOV	DS:signature, AL	; and give it to this block

	MOV	AX, ES:numBlks	; Add in size of
	INC	AX	; next blk plus
	ADD	DS:numBlks, AX	; size of header

DosFreeCombineAbove:
	MOV	AX, DS	; If block freed is
	CMP	AX, CS:firstMemBlk	; at the top of the chain
	JE	DosFreeOkExit	; then can't combine with block before this

	MOV	AX, DS
	MOV	ES, AX	; Save this blocks address in ES

	MOV	DS, BX
	CMP	DS:owner, 0	; If not a free block
	JNE	DosFreeOkExit	; exit

	MOV	AL, ES:signature	; Take next block's signature
	MOV	DS:signature, AL	; and give it to this block

	MOV	AX, ES:numBlks	; Add in size of
	INC	AX	; next blk plus
	ADD	DS:numBlks, AX	; size of header

DosFreeOkExit:
	CLC
	POP	AX	; Original AX
	JMP	SHORT DosFreeExit

DosFreeBadMemoryExit:
	STC
	MOV	AX, eMsMemoryTrashed
	POP	BX	; Clear stack
	JMP	SHORT DosFreeExit

DosFreeInvalidBlockExit:
	STC
	MOV	AX, eMsInvalidBlock
	POP	BX	; Clear stack

DosFreeExit:
	POP	BX
	POP	CX
	POP	DX
	POP	DI
	POP	SI
	POP	ES
	POP	DS
	RET
DosFree ENDP


CODE  ENDS

END   Start
